/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.filter;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllPackets;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.element.RenderElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.catnip.lang.FontHelper;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.content.logistics.filter.AbstractFilterMenu;
import com.zurrtum.create.infrastructure.packet.c2s.FilterScreenPacket;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_768;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractFilterScreen<F extends AbstractFilterMenu>
extends AbstractSimiContainerScreen<F> {
    protected AllGuiTextures background;
    private List<class_768> extraAreas = Collections.emptyList();
    private IconButton resetButton;
    private IconButton confirmButton;
    private ElementWidget renderedItem;

    protected AbstractFilterScreen(F menu, class_1661 inv, class_2561 title, AllGuiTextures background) {
        super(menu, inv, title);
        this.background = background;
    }

    @Override
    protected void method_25426() {
        this.setWindowSize(Math.max(this.background.getWidth(), AllGuiTextures.PLAYER_INVENTORY.getWidth()), this.background.getHeight() + 4 + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        super.method_25426();
        this.resetButton = new IconButton(this.field_2776 + this.background.getWidth() - 62, this.field_2800 + this.background.getHeight() - 24, AllIcons.I_TRASH);
        this.resetButton.withCallback(() -> {
            ((AbstractFilterMenu)this.field_2797).clearContents();
            this.contentsCleared();
            this.field_22787.field_1724.field_3944.method_52787((class_2596)AllPackets.CLEAR_CONTAINER);
        });
        this.confirmButton = new IconButton(this.field_2776 + this.background.getWidth() - 33, this.field_2800 + this.background.getHeight() - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.field_22787.field_1724.method_7346());
        this.method_37063(this.resetButton);
        this.method_37063(this.confirmButton);
        this.extraAreas = ImmutableList.of((Object)new class_768(this.field_2776 + this.background.getWidth(), this.field_2800 + this.background.getHeight() - 40, 80, 48));
        this.renderedItem = new ElementWidget(this.field_2776 + this.background.getWidth() + 8, this.field_2800 + this.background.getHeight() - 52).showingElement((RenderElement)GuiGameElement.of((class_1799)((AbstractFilterMenu)this.field_2797).contentHolder).scale(4.0f));
        this.method_37063(this.renderedItem);
    }

    @Override
    public void method_25432() {
        super.method_25432();
        this.renderedItem.getRenderElement().clear();
    }

    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.getWidth());
        int invY = this.field_2800 + this.background.getHeight() + 4;
        this.renderPlayerInventory(graphics, invX, invY);
        this.background.render(graphics, this.field_2776, this.field_2800);
        graphics.method_51439(this.field_22793, this.field_22785, this.field_2776 + (this.background.getWidth() - 8) / 2 - this.field_22793.method_27525((class_5348)this.field_22785) / 2, this.field_2800 + 4, this.getTitleColor(), false);
    }

    protected int getTitleColor() {
        return -10935260;
    }

    @Override
    protected void method_37432() {
        if (!class_1799.method_7973((class_1799)this.field_22787.field_1724.method_6047(), (class_1799)((class_1799)((AbstractFilterMenu)this.field_2797).contentHolder))) {
            this.field_22787.field_1724.method_7346();
        }
        super.method_37432();
        this.handleTooltips();
        this.handleIndicators();
    }

    protected void handleTooltips() {
        List<IconButton> tooltipButtons = this.getTooltipButtons();
        for (IconButton button : tooltipButtons) {
            if (button.getToolTip().isEmpty()) continue;
            button.setToolTip(button.getToolTip().get(0));
            button.getToolTip().add((class_2561)TooltipHelper.holdShift(FontHelper.Palette.YELLOW, AllKeys.hasShiftDown()));
        }
        if (AllKeys.hasShiftDown()) {
            List<class_5250> tooltipDescriptions = this.getTooltipDescriptions();
            for (int i = 0; i < tooltipButtons.size(); ++i) {
                this.fillToolTip(tooltipButtons.get(i), (class_2561)tooltipDescriptions.get(i));
            }
        }
    }

    public void handleIndicators() {
        for (IconButton button : this.getTooltipButtons()) {
            button.green = !this.isButtonEnabled(button);
        }
    }

    protected abstract boolean isButtonEnabled(IconButton var1);

    protected List<IconButton> getTooltipButtons() {
        return Collections.emptyList();
    }

    protected List<class_5250> getTooltipDescriptions() {
        return Collections.emptyList();
    }

    private void fillToolTip(IconButton button, class_2561 tooltip) {
        if (!button.method_25367()) {
            return;
        }
        List<class_2561> tip = button.getToolTip();
        tip.addAll(TooltipHelper.cutTextComponent(tooltip, FontHelper.Palette.ALL_GRAY));
    }

    protected void contentsCleared() {
    }

    protected void sendOptionUpdate(FilterScreenPacket.Option option) {
        this.field_22787.field_1724.field_3944.method_52787((class_2596)new FilterScreenPacket(option));
    }

    @Override
    public List<class_768> getExtraAreas() {
        return this.extraAreas;
    }
}

